﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Links;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class CancelAppointmentStep : FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.CancelAppointmentFakeResponseType))
            {
                if (state.PatEcRequest != null)
                    state.PatEcResponse = VistaFakeResponses.FakeCancelAppointmentResponse(state.CancelAppointmentFakeResponseType, state.PatEcRequest);
                if (state.ProEcRequest != null)
                    state.ProEcResponse = VistaFakeResponses.FakeCancelAppointmentResponse(state.CancelAppointmentFakeResponseType, state.ProEcRequest);
                return;
            }
            var ecRequests = new List<CancelEcRequest>();
            if (state.PatEcRequest != null)
                ecRequests.Add(new CancelEcRequest(Side.Patient, state.PatEcRequest));
            if (state.ProEcRequest != null)
                ecRequests.Add(new CancelEcRequest(Side.Provider, state.ProEcRequest));

            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(ecRequests, request =>
            {
                if (request.Side == Side.Patient && request.Request != null)
                {
                    state.PatEcResponse = request.Request.SendReceive<VIMTVIASchedCancApcancelAppointmentResponse>(MessageProcessType.Local);
                }
                if (request.Side == Side.Provider && request.Request != null)
                {
                    state.ProEcResponse = request.Request.SendReceive<VIMTVIASchedCancApcancelAppointmentResponse>(MessageProcessType.Local);
                }
            });
            timer.Stop();
            state.EcProcessingTimeMs = (int)timer.ElapsedMilliseconds;
        }
    }

    public class CancelEcRequest
    {
        public CancelEcRequest (Side side, VIMTVIASchedCancApcancelAppointmentRequest request)
        {
            Side = side;
            Request = request;
        }
        public VIMTVIASchedCancApcancelAppointmentRequest Request { get; set; }

        public Side Side { get; set; }


    }
}
